export interface Prize {
  id: string;
  name: string;
  color: string;
  probability: number;
}

export const defaultPrizes: Prize[] = [
  { id: '1', name: '100.000', color: '#dc2626', probability: 10 },
  { id: '2', name: 'ZONK', color: '#1f2937', probability: 30 },
  { id: '3', name: '50.000', color: '#dc2626', probability: 15 },
  { id: '4', name: 'ZONK', color: '#1f2937', probability: 25 },
  { id: '5', name: '200.000', color: '#dc2626', probability: 5 },
  { id: '6', name: 'ZONK', color: '#1f2937', probability: 10 },
  { id: '7', name: '30.000', color: '#dc2626', probability: 4 },
  { id: '8', name: 'ZONK', color: '#1f2937', probability: 1 }
];

export const getPrizes = (): Prize[] => {
  const stored = localStorage.getItem('luckySpinPrizes');
  return stored ? JSON.parse(stored) : defaultPrizes;
};

export const savePrizes = (prizes: Prize[]): void => {
  localStorage.setItem('luckySpinPrizes', JSON.stringify(prizes));
};

export const getRandomPrize = (): Prize => {
  const prizes = getPrizes();
  const totalProbability = prizes.reduce((sum, prize) => sum + prize.probability, 0);
  const random = Math.random() * totalProbability;
  
  let currentSum = 0;
  for (const prize of prizes) {
    currentSum += prize.probability;
    if (random <= currentSum) {
      return prize;
    }
  }
  
  return prizes[0];
};