# Project Summary
The Lucky Spin project is an engaging web application that simulates a spinning wheel experience, allowing users to claim prizes in a visually captivating, casino-themed interface. It features a user-facing website for spinning the wheel and claiming rewards, as well as an administrator panel for managing prizes. The project emphasizes delivering a smooth user experience with rich animations and responsive design. The application is now ready for production with optimized build outputs.

# Project Module Description
- **User Website**: An interactive Lucky Wheel where users enter their username and ticket code to spin and claim prizes.
- **Admin Website**: A management panel for administrators to add, edit, and delete prize entries, now hosted on a separate domain.

# Directory Tree
```
shadcn-ui/
├── README.md                  # Project overview and setup instructions
├── components.json            # Configuration for UI components
├── eslint.config.js           # ESLint configuration
├── index.html                 # Main HTML file
├── package.json               # Project dependencies and scripts
├── postcss.config.js          # PostCSS configuration
├── public/                    # Public assets
│   ├── assets/
│   │   ├── reference.png      # Reference image for design
│   │   └── image (1).png      # User-uploaded image for application
│   ├── favicon.svg            # Favicon for the application
│   └── robots.txt             # Robots.txt file
├── src/                       # Source code
│   ├── App.css                # Main CSS styles
│   ├── App.tsx                # Main application component
│   ├── components/            # Contains all UI components
│   ├── hooks/                 # Custom hooks
│   ├── lib/                   # Utility functions and prize management
│   ├── pages/                 # Application pages
│   ├── vite-env.d.ts          # TypeScript environment definitions
│   ├── vite.config.ts         # Vite configuration
├── tailwind.config.ts         # Tailwind CSS configuration
└── tsconfig.*.json            # TypeScript configurations
```

# File Description Inventory
- **README.md**: Documentation for project setup and usage.
- **index.html**: The entry point for the application.
- **src/App.tsx**: Main application logic including routing.
- **src/pages/**: Contains the main pages for user interaction.
- **src/components/**: UI components utilized throughout the application.
- **src/lib/prizes.ts**: Prize management functions and data structure.
- **src/hooks/**: Custom hooks for application state management.
- **public/assets/image (1).png**: User-uploaded image available for use in the application.
- **dist/**: Contains build output files for production deployment, including:
  - `index.html`
  - `assets/index-CVBg0IWR.css`
  - `assets/index-CrSzD_qr.js`

# Technology Stack
- **Frontend**: React, TypeScript, Tailwind CSS
- **Build Tool**: Vite
- **State Management**: React Query
- **Styling**: PostCSS, Tailwind CSS

# Usage
1. Clone the repository.
2. Navigate to the project directory.
3. Install dependencies: `pnpm install`
4. Build the project: `pnpm run build`
5. Run linting: `pnpm run lint`
6. Upload all files from the `dist/` folder to the root directory of your hosting.
7. Access the main application and admin panel via your domain.
